<?php

namespace App\Http\Controllers\Api\V1;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use DB;
use Illuminate\Http\Response;

use App\Http\Validators\TestValidators;
use Illuminate\Support\Facades\Validator;

use App\Test;
use App\FiltroEnvioTest;

class TestController extends Controller
{
    public function filtrar(Request $request){

        $user = auth()->user();

        $data = $request->input();

        $rules = TestValidators::$filtrar;
        $validator = Validator::make($data, $rules);

        if ($validator->fails()) {
            $message = null;
            foreach ($validator->errors()->getMessages() as $messageError) {
                foreach ($messageError as $error) {
                    $message .= "\n" . $error;
                }
            }
            return response()->json(['error' => trans('messages.generic.validation') . ' ' . $message], Response::HTTP_BAD_REQUEST);
        }


        if (is_null($user)) {
            return response()->json(['error' => trans('messages.user.not_found')], Response::HTTP_NOT_FOUND);
        }

        $filtros_tests = DB::table('users_filtro_envio_test')
                                ->select(
                                    'users_filtro_envio_test.*',
                                    'filtros_envio_test.*'
                                    )
                                ->join('filtros_envio_test', 'filtros_envio_test.id', '=', 'users_filtro_envio_test.id_filtro_envio_test')
                                ->where('users_filtro_envio_test.id_user',$user->id)
                                ->where('users_filtro_envio_test.flstatus',1)
                                ->get();

        $filtros_tests_id = [];

        foreach ($filtros_tests as $filtro_test){
            $id_filtro_test = explode(",",$filtro_test->id_filtro_envio_test);
            $filtros_tests_id = $id_filtro_test;
        }

        $registros_tests_data= [];

        foreach ($filtros_tests_id as $filtro_test_id){

            $filtro_envio_test_get = FiltroEnvioTest::find($filtro_test_id);

            $registros_tests = Test::select(
                            'registros_test.id',
                            'registros_test.fecha_registro as fecha_registro',
                            'registros_test.hora_inicio as hora_inicio',
                            'registros_test.hora_fin as hora_fin',
                            'registros_test.resultado as resultado',
                            'registros_test.idioma as idioma',

                            'registros_test.id_usuario',
                            'registros_usuarios.nombre as nombres_usuario',
                            'registros_usuarios.apellidos as apellidos_usuario',
                            'registros_usuarios.sexo as sexo_usuario',
                            'registros_usuarios.email as email_usuario',
                            'registros_usuarios.telefono as telefono_usuario',

                            'registros_test.institucion_1',
                            'ie1.title as nombre_institucion_1',
                            'ie1.alias as alias_institucion_1',
                            'ci1.id as id_categoria_institucion_1',
                            'ci1.title as nombre_categoria_institucion_1',

                            'registros_test.institucion_2',
                            'ie2.title as nombre_institucion_2',
                            'ie2.alias as alias_institucion_2',
                            'ci2.id as id_categoria_institucion_2',
                            'ci2.title as nombre_categoria_institucion_2',
                            
                            'c1.id as id_carrera_interes_1',
                            'c1.title as nombre_carrera_interes_1',
                            'cc1.id as id_categoria_carrera_1',
                            'cc1.title as nombre_categoria_carrera_1',
                            'sc1.id as id_subcategoria_carrera_1',
                            'sc1.title as nombre_subcategoria_carrera_1',
                            
                            'c2.id as id_carrera_interes_2',
                            'c2.title as nombre_carrera_interes_2',
                            'cc2.id as id_categoria_carrera_2',
                            'cc2.title as nombre_categoria_carrera_2',
                            'sc2.id as id_subcategoria_carrera_2',
                            'sc2.title as nombre_subcategoria_carrera_2',
                            
                            'c3.id as id_carrera_interes_3',
                            'c3.title as nombre_carrera_interes_3',
                            'cc3.id as id_categoria_carrera_3',
                            'cc3.title as nombre_categoria_carrera_3',
                            'sc3.id as id_subcategoria_carrera_3',
                            'sc3.title as nombre_subcategoria_carrera_3',
                            
                            'departamentos.id as id_departamento',
                            'departamentos.departamento as nombre_departamento',
                            'provincias.id as id_provincia',
                            'provincias.provincia as nombre_provincia',
                            'distritos.id as id_distrito',
                            'distritos.distrito as nombre_distrito',
                        )
                    ->join('registros_usuarios', 'registros_usuarios.id', '=', 'registros_test.id_usuario')
                    
                    ->leftJoin('carreras as c1', 'c1.id', '=', 'registros_test.carrera_1')
                    ->leftJoin('categorias_carreras as cc1', 'cc1.id', '=', 'c1.id_categoria')
                    ->leftJoin('subcategorias_carreras as sc1', 'sc1.id', '=', 'c1.id_subcategoria')

                    ->leftJoin('carreras as c2', 'c2.id', '=', 'registros_test.carrera_2')
                    ->leftJoin('categorias_carreras as cc2', 'cc2.id', '=', 'c2.id_categoria')
                    ->leftJoin('subcategorias_carreras as sc2', 'sc2.id', '=', 'c2.id_subcategoria')

                    ->leftJoin('carreras as c3', 'c3.id', '=', 'registros_test.carrera_3')
                    ->leftJoin('categorias_carreras as cc3', 'cc3.id', '=', 'c3.id_categoria')
                    ->leftJoin('subcategorias_carreras as sc3', 'sc3.id', '=', 'c3.id_subcategoria')
                    
                    ->leftJoin('instituciones_educativas as ie1', 'ie1.id', '=', 'registros_test.institucion_1')
                    ->leftJoin('categorias_instituciones as ci1', 'ci1.id', '=', 'ie1.id_categoria')

                    ->leftJoin('instituciones_educativas as ie2', 'ie2.id', '=', 'registros_test.institucion_2')
                    ->leftJoin('categorias_instituciones as ci2', 'ci2.id', '=', 'ie2.id_categoria')

                    ->join('departamentos', 'departamentos.id', '=', 'registros_usuarios.id_departamento')
                    ->join('provincias', 'provincias.id', '=', 'registros_usuarios.id_provincia')
                    ->join('distritos', 'distritos.id', '=', 'registros_usuarios.id_distrito');

                    
            if(!is_null($data['fecha_inicio'])){
                $registros_tests = $registros_tests->where('registros_test.fecha_registro','>=',$data['fecha_inicio']);
            } 

            if(!is_null($data['fecha_fin'])){
                $registros_tests = $registros_tests->where('registros_test.fecha_registro','<=',$data['fecha_fin']);
            } 

            if(!empty($filtro_envio_test_get->agno_egresado)){
                $registros_tests = $registros_tests->whereIn('registros_usuarios.agno_egresado',[$filtro_envio_test_get->agno_egresado]);
            } 
                    
            if(!empty($filtro_envio_test_get->sexo) || $filtro_test->sexo != 0){
                $registros_tests = $registros_tests->whereIn('registros_usuarios.sexo',[$filtro_envio_test_get->sexo]);
            } 
            
            if(!empty($filtro_envio_test_get->paises)){
                $registros_tests = $registros_tests->whereIn('registros_usuarios.id_pais',[$filtro_envio_test_get->paises]);
            } 
            
            if(!empty($filtro_envio_test_get->departamentos)){
                $registros_tests = $registros_tests->whereIn('registros_usuarios.id_departamento',[$filtro_envio_test_get->departamentos]);
            } 

            if(!empty($filtro_envio_test_get->provincias)){
                $registros_tests = $registros_tests->whereIn('registros_usuarios.id_provincia',[$filtro_envio_test_get->provincias]);
            } 

            if(!empty($filtro_envio_test_get->distritos)){
                $registros_tests = $registros_tests->whereIn('registros_usuarios.id_distrito',[$filtro_envio_test_get->distritos]);
            } 

            if(!empty($filtro_envio_test_get->carreras)){
                $registros_tests = $registros_tests->where(function ( $query) use ($filtro_envio_test_get){
                    $query->whereIn('registros_test.carrera_1', [$filtro_envio_test_get->carreras])
                          ->orWhereIn('registros_test.carrera_2', [$filtro_envio_test_get->carreras])
                          ->orWhereIn('registros_test.carrera_3', [$filtro_envio_test_get->carreras]);
                });
            } 

            
            if(!empty($filtro_envio_test_get->instituciones)){
                $registros_tests = $registros_tests->where(function ( $query) use ($filtro_envio_test_get){
                    $query->whereIn('registros_test.institucion_1', [$filtro_envio_test_get->instituciones])
                          ->orWhereIn('registros_test.institucion_2', [$filtro_envio_test_get->instituciones]);
                });
            }

            $registros_tests = $registros_tests
                                    ->orderBy('registros_test.fecha_registro', 'desc')
                                    ->get();

                                    
            //$registros_tests_data['filtro_envio_test_'.$filtro_test_id] = $registros_tests;

            $registros_tests_data[] = [
                'id_filtro_test' => $filtro_test_id,
                'titulo_filtro_test' => $filtro_envio_test_get->titulo,
                'result' => $registros_tests
                ];  
        }

        return response()->json([
                    'response' => Response::HTTP_OK,
                    'result' => $registros_tests_data
        ]);

    }
}
