<?php

namespace App\Http\Controllers\Api\V1;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use DB;
use Illuminate\Http\Response;

use App\Http\Validators\ConsultaDirectaValidators;
use Illuminate\Support\Facades\Validator;

use App\ConsultaDirecta;
use App\FiltroConsulta;

class ConsultaDirectaController extends Controller
{
    public function listar(Request $request){

        $user = auth()->user();

        $data = $request->input();

        $rules = ConsultaDirectaValidators::$listar;
        $validator = Validator::make($data, $rules);

        if ($validator->fails()) {
            $message = null;
            foreach ($validator->errors()->getMessages() as $messageError) {
                foreach ($messageError as $error) {
                    $message .= "\n" . $error;
                }
            }
            return response()->json(['error' => trans('messages.generic.validation') . ' ' . $message], Response::HTTP_BAD_REQUEST);
        }

        if (is_null($user)) {
            return response()->json(['error' => trans('messages.user.not_found')], Response::HTTP_NOT_FOUND);
        }

        $instituciones_educativas = DB::table('users_institucion')
                                ->select('users_institucion.id_institucion')
                                ->where('id_user',$user->id)
                                ->where('flstatus',1)
                                ->get();

        $instituciones_educativas_id = [];

        foreach ($instituciones_educativas as $institucion_educativa){
            $id_instituciones = explode(",",$institucion_educativa->id_institucion);
            $instituciones_educativas_id = $id_instituciones;
        }

        $consultas_directas_result = [];

        foreach ($instituciones_educativas_id as $institucion_educativa_id){
            $consultas_directas = ConsultaDirecta::select(
                'consultas_directas.id',
                'consultas_directas.id_institucion',
                'instituciones_educativas.title as nombre_institucion',
                'instituciones_educativas.alias as alias_institucion',
                
                'categorias_instituciones.id as id_categoria_institucion',
                'categorias_instituciones.title as nombre_categoria_institucion',

                'consultas_directas.fecha as fecha_consulta',
                'consultas_directas.hora as hora_consulta',
                'consultas_directas.mensaje as consulta',
                'registros_usuarios.nombre as nombres_usuario',
                'registros_usuarios.apellidos as apellidos_usuario',
                'registros_usuarios.sexo as sexo_usuario',
                'registros_usuarios.email as email_usuario',
                'registros_usuarios.telefono as telefono_usuario',

                'c1.title as carrera_interes_1',
                'cc1.id as id_categoria_carrera_1',
                'cc1.title as nombre_categoria_carrera_1',
                'sc1.id as id_subcategoria_carrera_1',
                'sc1.title as nombre_subcategoria_carrera_1',

                'c2.title as carrera_interes_2',
                'cc2.id as id_categoria_carrera_2',
                'cc2.title as nombre_categoria_carrera_2',
                'sc2.id as id_subcategoria_carrera_2',
                'sc2.title as nombre_subcategoria_carrera_2',

                'c3.title as carrera_interes_3',
                'cc3.id as id_categoria_carrera_3',
                'cc3.title as nombre_categoria_carrera_3',
                'sc3.id as id_subcategoria_carrera_3',
                'sc3.title as nombre_subcategoria_carrera_3',
                
                'departamentos.id as id_departamento',
                'departamentos.departamento as nombre_departamento',
                'provincias.id as id_provincia',
                'provincias.provincia as nombre_provincia',
                'distritos.id as id_distrito',
                'distritos.distrito as nombre_distrito',
                )
            ->join('instituciones_educativas', 'instituciones_educativas.id', '=', 'consultas_directas.id_institucion')
            ->join('registros_usuarios', 'registros_usuarios.id', '=', 'consultas_directas.id_usuario')
            ->leftJoin('carreras as c1', 'c1.id', '=', 'consultas_directas.carrera_interes_1')
            ->leftJoin('categorias_carreras as cc1', 'cc1.id', '=', 'c1.id_categoria')
            ->leftJoin('subcategorias_carreras as sc1', 'sc1.id', '=', 'c1.id_subcategoria')

            ->leftJoin('carreras as c2', 'c2.id', '=', 'consultas_directas.carrera_interes_2')
            ->leftJoin('categorias_carreras as cc2', 'cc2.id', '=', 'c2.id_categoria')
            ->leftJoin('subcategorias_carreras as sc2', 'sc2.id', '=', 'c2.id_subcategoria')

            ->leftJoin('carreras as c3', 'c3.id', '=', 'consultas_directas.carrera_interes_3')
            ->leftJoin('categorias_carreras as cc3', 'cc3.id', '=', 'c3.id_categoria')
            ->leftJoin('subcategorias_carreras as sc3', 'sc3.id', '=', 'c3.id_subcategoria')


            ->join('departamentos', 'departamentos.id', '=', 'registros_usuarios.id_departamento')
            ->join('provincias', 'provincias.id', '=', 'registros_usuarios.id_provincia')
            ->join('distritos', 'distritos.id', '=', 'registros_usuarios.id_distrito')
            ->join('categorias_instituciones', 'categorias_instituciones.id', '=', 'instituciones_educativas.id_categoria')
            ->where('consultas_directas.id_institucion',$institucion_educativa_id);

            if(!is_null($data['fecha_inicio'])){
                $consultas_directas = $consultas_directas->where('consultas_directas.fecha','>=',$data['fecha_inicio']);
            } 

            if(!is_null($data['fecha_fin'])){
                $consultas_directas = $consultas_directas->where('consultas_directas.fecha','<=',$data['fecha_fin']);
            } 
            
            if(!is_null($data['telefono_verificado'])){
                $consultas_directas = $consultas_directas->where('registros_usuarios.telefono_verificado',$data['telefono_verificado']);
            } 
            
            if(!is_null($data['sexo'])){
                $consultas_directas = $consultas_directas->where('registros_usuarios.sexo',$data['sexo']);
            } 
            
            if(!is_null($data['id_departamento'])){
                $consultas_directas = $consultas_directas->where('registros_usuarios.id_departamento',$data['id_departamento']);
            } 
            
            if(!is_null($data['id_provincia'])){
                $consultas_directas = $consultas_directas->where('registros_usuarios.id_provincia',$data['id_provincia']);
            } 
            
            if(!is_null($data['id_distrito'])){
                $consultas_directas = $consultas_directas->where('registros_usuarios.id_distrito',$data['id_distrito']);
            } 

            $consultas_directas = $consultas_directas
                                    ->orderBy('consultas_directas.fecha', 'desc')
                                    ->get();

            //$consultas_directas_result[$institucion_educativa_id] = $consultas_directas;
            
            $consultas_directas_result[] = [
                'id' => $institucion_educativa_id,
                'result' => $consultas_directas
                ];  
        }

       

        return response()->json([
                    'response' => Response::HTTP_OK,
                    'result' => $consultas_directas_result
        ]);

    }

    public function filtrar(Request $request){

        $user = auth()->user();

        $data = $request->input();

        $rules = ConsultaDirectaValidators::$filtrar;
        $validator = Validator::make($data, $rules);

        if ($validator->fails()) {
            $message = null;
            foreach ($validator->errors()->getMessages() as $messageError) {
                foreach ($messageError as $error) {
                    $message .= "\n" . $error;
                }
            }
            return response()->json(['error' => trans('messages.generic.validation') . ' ' . $message], Response::HTTP_BAD_REQUEST);
        }


        if (is_null($user)) {
            return response()->json(['error' => trans('messages.user.not_found')], Response::HTTP_NOT_FOUND);
        }

        $filtros_consultas = DB::table('users_filtro_consulta')
                                ->select(
                                    'users_filtro_consulta.*',
                                    'filtros_consultas.*'
                                    )
                                ->join('filtros_consultas', 'filtros_consultas.id', '=', 'users_filtro_consulta.id_filtro_consulta')
                                ->where('users_filtro_consulta.id_user',$user->id)
                                ->where('users_filtro_consulta.flstatus',1)
                                ->get();

        $filtros_consultas_id = [];

        foreach ($filtros_consultas as $filtro_consulta){
            $id_filtro_consulta = explode(",",$filtro_consulta->id_filtro_consulta);
            $filtros_consultas_id = $id_filtro_consulta;
        }

        $filtros_consultas_data = [];

        foreach ($filtros_consultas_id as $filtro_consulta_id){

            $filtro_consulta_get = FiltroConsulta::find($filtro_consulta_id);

            $consultas_directas = ConsultaDirecta::select(
                            'consultas_directas.id',
                            'consultas_directas.id_institucion',
                            'instituciones_educativas.title as nombre_institucion',
                            'instituciones_educativas.alias as alias_institucion',
                            
                            'categorias_instituciones.id as id_categoria_institucion',
                            'categorias_instituciones.title as nombre_categoria_institucion',

                            'consultas_directas.fecha as fecha_consulta',
                            'consultas_directas.hora as hora_consulta',
                            'consultas_directas.mensaje as consulta',
                            'registros_usuarios.nombre as nombres_usuario',
                            'registros_usuarios.apellidos as apellidos_usuario',
                            'registros_usuarios.sexo as sexo_usuario',
                            'registros_usuarios.email as email_usuario',
                            'registros_usuarios.telefono as telefono_usuario',

                            
                            'c1.id as id_carrera_interes_1',
                            'c1.title as nombre_carrera_interes_1',
                            'cc1.id as id_categoria_carrera_1',
                            'cc1.title as nombre_categoria_carrera_1',
                            'sc1.id as id_subcategoria_carrera_1',
                            'sc1.title as nombre_subcategoria_carrera_1',

                            
                            'c2.id as id_carrera_interes_2',
                            'c2.title as nombre_carrera_interes_2',
                            'cc2.id as id_categoria_carrera_2',
                            'cc2.title as nombre_categoria_carrera_2',
                            'sc2.id as id_subcategoria_carrera_2',
                            'sc2.title as nombre_subcategoria_carrera_2',

                            
                            'c3.id as id_carrera_interes_3',
                            'c3.title as nombre_carrera_interes_3',
                            'cc3.id as id_categoria_carrera_3',
                            'cc3.title as nombre_categoria_carrera_3',
                            'sc3.id as id_subcategoria_carrera_3',
                            'sc3.title as nombre_subcategoria_carrera_3',
                            
                            'departamentos.id as id_departamento',
                            'departamentos.departamento as nombre_departamento',
                            'provincias.id as id_provincia',
                            'provincias.provincia as nombre_provincia',
                            'distritos.id as id_distrito',
                            'distritos.distrito as nombre_distrito',
                        )
                    ->join('instituciones_educativas', 'instituciones_educativas.id', '=', 'consultas_directas.id_institucion')
                    ->join('registros_usuarios', 'registros_usuarios.id', '=', 'consultas_directas.id_usuario')
                    ->leftJoin('carreras as c1', 'c1.id', '=', 'consultas_directas.carrera_interes_1')
                    ->leftJoin('categorias_carreras as cc1', 'cc1.id', '=', 'c1.id_categoria')
                    ->leftJoin('subcategorias_carreras as sc1', 'sc1.id', '=', 'c1.id_subcategoria')

                    ->leftJoin('carreras as c2', 'c2.id', '=', 'consultas_directas.carrera_interes_2')
                    ->leftJoin('categorias_carreras as cc2', 'cc2.id', '=', 'c2.id_categoria')
                    ->leftJoin('subcategorias_carreras as sc2', 'sc2.id', '=', 'c2.id_subcategoria')

                    ->leftJoin('carreras as c3', 'c3.id', '=', 'consultas_directas.carrera_interes_3')
                    ->leftJoin('categorias_carreras as cc3', 'cc3.id', '=', 'c3.id_categoria')
                    ->leftJoin('subcategorias_carreras as sc3', 'sc3.id', '=', 'c3.id_subcategoria')


                    ->join('departamentos', 'departamentos.id', '=', 'registros_usuarios.id_departamento')
                    ->join('provincias', 'provincias.id', '=', 'registros_usuarios.id_provincia')
                    ->join('distritos', 'distritos.id', '=', 'registros_usuarios.id_distrito')
                    ->join('categorias_instituciones', 'categorias_instituciones.id', '=', 'instituciones_educativas.id_categoria');

                    
            if(!is_null($data['fecha_inicio'])){
                $consultas_directas = $consultas_directas->where('consultas_directas.fecha','>=',$data['fecha_inicio']);
            } 

            if(!is_null($data['fecha_fin'])){
                $consultas_directas = $consultas_directas->where('consultas_directas.fecha','<=',$data['fecha_fin']);
            } 

            if(!empty($filtro_consulta_get->agno_egresado)){
                $consultas_directas = $consultas_directas->whereIn('registros_usuarios.agno_egresado',[$filtro_consulta_get->agno_egresado]);
            } 
                    
            if(!empty($filtro_consulta_get->sexo) || $filtro_consulta_get->sexo != 0){
                $consultas_directas = $consultas_directas->whereIn('registros_usuarios.sexo',[$filtro_consulta_get->sexo]);
            } 

            if(!empty($filtro_consulta_get->instituciones)){
                $consultas_directas = $consultas_directas->whereIn('consultas_directas.id_institucion',[$filtro_consulta_get->instituciones]);
            } 
            
            if(!empty($filtro_consulta_get->paises)){
                $consultas_directas = $consultas_directas->whereIn('registros_usuarios.id_pais',[$filtro_consulta_get->paises]);
            } 
            
            if(!empty($filtro_consulta_get->departamentos)){
                $consultas_directas = $consultas_directas->whereIn('registros_usuarios.id_departamento',[$filtro_consulta_get->departamentos]);
            } 

            if(!empty($filtro_consulta_get->provincias)){
                $consultas_directas = $consultas_directas->whereIn('registros_usuarios.id_provincia',[$filtro_consulta_get->provincias]);
            } 

            if(!empty($filtro_consulta_get->distritos)){
                $consultas_directas = $consultas_directas->whereIn('registros_usuarios.id_distrito',[$filtro_consulta_get->distritos]);
            } 

            if(!empty($filtro_consulta_get->carreras)){
                $consultas_directas = $consultas_directas->where(function ( $query) use ($filtro_consulta_get){
                    $query->whereIn('consultas_directas.carrera_interes_1', [$filtro_consulta_get->carreras])
                          ->orWhereIn('consultas_directas.carrera_interes_2', [$filtro_consulta_get->carreras])
                          ->orWhereIn('consultas_directas.carrera_interes_3', [$filtro_consulta_get->carreras]);
                });
            } 

            $consultas_directas = $consultas_directas
                                    ->orderBy('consultas_directas.fecha', 'desc')
                                    ->get();

            //$filtros_consultas_data['filtro_consulta_'.$filtro_consulta_id] = $consultas_directas;

            $filtros_consultas_data[] = [
                'id_filtro_consulta' => $filtro_consulta_id,
                'titulo_filtro_consulta' => $filtro_consulta_get->titulo,
                'result' => $consultas_directas
                ];  
        }

        return response()->json([
                    'response' => Response::HTTP_OK,
                    'result' => $filtros_consultas_data
        ]);

    }
}
