<?php

use Illuminate\Http\Request;

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\LlamadaController;
use App\Http\Controllers\ConsultaDirectaController;
use App\Http\Controllers\TestController;
use App\Http\Controllers\IframeTestController;



/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

/*Route::middleware('auth:api')->get('/user', function (Request $request) {
    return $request->user();
});*/

Route::group([
    'middleware' => 'api',
    'prefix' => 'v1/auth'

], function ($router) {
    Route::post('login', [\App\Http\Controllers\Api\V1\AuthController::class, 'login'])->name('login');
    Route::post('logout', [\App\Http\Controllers\Api\V1\AuthController::class, 'logout'])->name('logout');
    Route::post('refresh', [\App\Http\Controllers\Api\V1\AuthController::class, 'refresh'])->name('refresh');
    Route::post('me', [\App\Http\Controllers\Api\V1\AuthController::class, 'me'])->name('me');
});

Route::group([
    'middleware' => 'api',
    'prefix' => 'v1/llamada'

], function ($router) {
    Route::post('listar', [\App\Http\Controllers\Api\V1\LlamadaController::class, 'listar'])->name('listar');
});

Route::group([
    'middleware' => 'api',
    'prefix' => 'v1/consulta'

], function ($router) {
    Route::post('directa/listar', [\App\Http\Controllers\Api\V1\ConsultaDirectaController::class, 'listar'])->name('listar');
    Route::post('directa/filtrar', [\App\Http\Controllers\Api\V1\ConsultaDirectaController::class, 'filtrar'])->name('filtrar');
});


Route::group([
    'middleware' => 'api',
    'prefix' => 'v1/test'

], function ($router) {
    Route::post('real/filtrar', [\App\Http\Controllers\Api\V1\TestController::class, 'filtrar'])->name('filtrar');
});


Route::group([
    'middleware' => 'api',
    'prefix' => 'v1/iframe'

], function ($router) {
    Route::post('test/filtrar', [\App\Http\Controllers\Api\V1\IframeTestController::class, 'filtrar'])->name('filtrar');
});

