<?php

namespace App\Http\Controllers\Api\V1;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use DB;
use Illuminate\Http\Response;
use App\Llamada;


class LlamadaController extends Controller
{


    public function listar(){

        $user = auth()->user();

        if (is_null($user)) {
            return response()->json(['error' => trans('messages.user.not_found')], Response::HTTP_NOT_FOUND);
        }

        $instituciones_educativas = DB::table('users_institucion')
                                ->select('users_institucion.id_institucion')
                                ->where('id_user',$user->id)
                                ->where('flstatus',1)
                                ->get();

        $instituciones_educativas_id = [];

        foreach ($instituciones_educativas as $institucion_educativa){
            $id_instituciones = explode(",",$institucion_educativa->id_institucion);
            $instituciones_educativas_id = $id_instituciones;
        }

        $registros_llamadas=[];

        foreach ($instituciones_educativas_id as $institucion_educativa_id){
            $llamadas = Llamada::select(
                'registros_llamadas.id',
                'registros_llamadas.id_institucion',
                'instituciones_educativas.title as nombre_institucion',
                'instituciones_educativas.alias as alias_institucion',
                'registros_llamadas.ip',
                'registros_llamadas.telefono',
                'registros_llamadas.telefono_usuario',
                'registros_llamadas.fecha'
                )
            ->join('instituciones_educativas', 'instituciones_educativas.id', '=', 'registros_llamadas.id_institucion')
            ->where('registros_llamadas.id_institucion',$institucion_educativa_id)
            ->get();

            $registros_llamadas[] = [
                                    'id' => $institucion_educativa_id,
                                    'result' => $llamadas
                                    ];  
        }

        return response()->json([
                    'response' => Response::HTTP_OK,
                    'result' => $registros_llamadas
        ]);

    }
}
