<?php

namespace App\Http\Controllers\Api\V1;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use DB;
use Illuminate\Http\Response;

use App\Http\Validators\IframeTestValidators;
use Illuminate\Support\Facades\Validator;


use App\IframeTest;
use App\Iframe;
use App\FiltroEnvioTest;

class IframeTestController extends Controller
{
    public function filtrar(Request $request){

        $user = auth()->user();

        $data = $request->input();

        $rules = IframeTestValidators::$filtrar;
        $validator = Validator::make($data, $rules);

        if ($validator->fails()) {
            $message = null;
            foreach ($validator->errors()->getMessages() as $messageError) {
                foreach ($messageError as $error) {
                    $message .= "\n" . $error;
                }
            }
            return response()->json(['error' => trans('messages.generic.validation') . ' ' . $message], Response::HTTP_BAD_REQUEST);
        }


        if (is_null($user)) {
            return response()->json(['error' => trans('messages.user.not_found')], Response::HTTP_NOT_FOUND);
        }

        $iframes_filtros_tests = DB::table('users_iframe_registro_test')
                                ->select(
                                    'users_iframe_registro_test.*',
                                    'filtros_envio_test.*'
                                    )
                                ->join('iframes', 'iframes.id', '=', 'users_iframe_registro_test.id_iframe')
                                ->join('filtros_envio_test', 'filtros_envio_test.id', '=', 'users_iframe_registro_test.id_filtro_envio_test')
                                ->where('users_iframe_registro_test.id_user',$user->id)
                                ->where('users_iframe_registro_test.flstatus',1)
                                ->get();

        $iframes_filtros_tests_id_iframe = [];

        foreach ($iframes_filtros_tests as $iframe_filtro_test){
            $id_iframe = explode(",",$iframe_filtro_test->id_iframe);
            $iframes_filtros_tests_id_iframe = $id_iframe;
            $iframes_filtros_tests_id_filtro_envio_test= $iframe_filtro_test->id_filtro_envio_test;
        }

        $iframes_registros_test_data= [];

        foreach ($iframes_filtros_tests_id_iframe as $iframe_filtro_test_id_iframe){

            $iframe = Iframe::find($iframe_filtro_test_id_iframe);

            $data_iframes_filtros = $this->iframeRegistroTest($iframe_filtro_test_id_iframe,$iframes_filtros_tests_id_filtro_envio_test, $data);
            //$iframes_registros_test_data['iframe_id_'.$iframe_filtro_test_id_iframe] = $data_iframes_filtros;
            
            $iframes_registros_test_data[] = [
                'id_iframe' => $iframe_filtro_test_id_iframe,
                'titulo_iframe' => $iframe->titulo,
                'result' => $data_iframes_filtros
                ];  
        }

        return response()->json([
                    'response' => Response::HTTP_OK,
                    'result' => $iframes_registros_test_data
        ]);

    }

    public function iframeRegistroTest($id_iframe=null, $id_filtro_envio_test=null,$data ){

        $iframes_filtros_tests_id_filtro = [];
        $id_filtros = explode(",",$id_filtro_envio_test);
        $iframes_filtros_tests_id_filtro = $id_filtros;

        foreach ($iframes_filtros_tests_id_filtro as $iframe_filtro_test_id_filtro){

            $filtro_envio_test_get = FiltroEnvioTest::find($iframe_filtro_test_id_filtro);

            $iframes_registros_test = IframeTest::select(
                'iframes_registros_test.id',
                'iframes_registros_test.fecha_registro as fecha_registro',
                'iframes_registros_test.hora_inicio as hora_inicio',
                'iframes_registros_test.hora_fin as hora_fin',
                'iframes_registros_test.resultado as resultado',
                'iframes_registros_test.idioma as idioma',

                'iframes_registros_test.id_usuario',
                'registros_usuarios.nombre as nombres_usuario',
                'registros_usuarios.apellidos as apellidos_usuario',
                'registros_usuarios.sexo as sexo_usuario',
                'registros_usuarios.email as email_usuario',
                'registros_usuarios.telefono as telefono_usuario',

                'iframes_registros_test.institucion_1',
                'ie1.title as nombre_institucion_1',
                'ie1.alias as alias_institucion_1',
                'ci1.id as id_categoria_institucion_1',
                'ci1.title as nombre_categoria_institucion_1',

                'iframes_registros_test.institucion_2',
                'ie2.title as nombre_institucion_2',
                'ie2.alias as alias_institucion_2',
                'ci2.id as id_categoria_institucion_2',
                'ci2.title as nombre_categoria_institucion_2',
                
                'c1.id as id_carrera_interes_1',
                'c1.title as nombre_carrera_interes_1',
                'cc1.id as id_categoria_carrera_1',
                'cc1.title as nombre_categoria_carrera_1',
                'sc1.id as id_subcategoria_carrera_1',
                'sc1.title as nombre_subcategoria_carrera_1',
                
                'c2.id as id_carrera_interes_2',
                'c2.title as nombre_carrera_interes_2',
                'cc2.id as id_categoria_carrera_2',
                'cc2.title as nombre_categoria_carrera_2',
                'sc2.id as id_subcategoria_carrera_2',
                'sc2.title as nombre_subcategoria_carrera_2',
                
                'c3.id as id_carrera_interes_3',
                'c3.title as nombre_carrera_interes_3',
                'cc3.id as id_categoria_carrera_3',
                'cc3.title as nombre_categoria_carrera_3',
                'sc3.id as id_subcategoria_carrera_3',
                'sc3.title as nombre_subcategoria_carrera_3',
            
                'departamentos.id as id_departamento',
                'departamentos.departamento as nombre_departamento',
                'provincias.id as id_provincia',
                'provincias.provincia as nombre_provincia',
                'distritos.id as id_distrito',
                'distritos.distrito as nombre_distrito',
            )
            ->join('registros_usuarios', 'registros_usuarios.id', '=', 'iframes_registros_test.id_usuario')
            
            ->leftJoin('carreras as c1', 'c1.id', '=', 'iframes_registros_test.carrera_1')
            ->leftJoin('categorias_carreras as cc1', 'cc1.id', '=', 'c1.id_categoria')
            ->leftJoin('subcategorias_carreras as sc1', 'sc1.id', '=', 'c1.id_subcategoria')

            ->leftJoin('carreras as c2', 'c2.id', '=', 'iframes_registros_test.carrera_2')
            ->leftJoin('categorias_carreras as cc2', 'cc2.id', '=', 'c2.id_categoria')
            ->leftJoin('subcategorias_carreras as sc2', 'sc2.id', '=', 'c2.id_subcategoria')

            ->leftJoin('carreras as c3', 'c3.id', '=', 'iframes_registros_test.carrera_3')
            ->leftJoin('categorias_carreras as cc3', 'cc3.id', '=', 'c3.id_categoria')
            ->leftJoin('subcategorias_carreras as sc3', 'sc3.id', '=', 'c3.id_subcategoria')
            
            ->leftJoin('instituciones_educativas as ie1', 'ie1.id', '=', 'iframes_registros_test.institucion_1')
            ->leftJoin('categorias_instituciones as ci1', 'ci1.id', '=', 'ie1.id_categoria')

            ->leftJoin('instituciones_educativas as ie2', 'ie2.id', '=', 'iframes_registros_test.institucion_2')
            ->leftJoin('categorias_instituciones as ci2', 'ci2.id', '=', 'ie2.id_categoria')

            ->join('departamentos', 'departamentos.id', '=', 'registros_usuarios.id_departamento')
            ->join('provincias', 'provincias.id', '=', 'registros_usuarios.id_provincia')
            ->join('distritos', 'distritos.id', '=', 'registros_usuarios.id_distrito');

            
            if(!is_null($data['fecha_inicio'])){
                $iframes_registros_test = $iframes_registros_test->where('iframes_registros_test.fecha_registro','>=',$data['fecha_inicio']);
            } 

            if(!is_null($data['fecha_fin'])){
                $iframes_registros_test = $iframes_registros_test->where('iframes_registros_test.fecha_registro','<=',$data['fecha_fin']);
            } 

            if(!empty($filtro_envio_test_get->agno_egresado)){
                $iframes_registros_test = $iframes_registros_test->whereIn('registros_usuarios.agno_egresado',[$filtro_envio_test_get->agno_egresado]);
            } 
                    
            if(!empty($filtro_envio_test_get->sexo) || $filtro_envio_test_get->sexo != 0){
                $iframes_registros_test = $iframes_registros_test->whereIn('registros_usuarios.sexo',[$filtro_envio_test_get->sexo]);
            } 

            if(!empty($filtro_envio_test_get->paises)){
                $iframes_registros_test = $iframes_registros_test->whereIn('registros_usuarios.id_pais',[$filtro_envio_test_get->paises]);
            } 

            if(!empty($filtro_envio_test_get->departamentos)){
                $iframes_registros_test = $iframes_registros_test->whereIn('registros_usuarios.id_departamento',[$filtro_envio_test_get->departamentos]);
            } 

            if(!empty($filtro_envio_test_get->provincias)){
                $iframes_registros_test = $iframes_registros_test->whereIn('registros_usuarios.id_provincia',[$filtro_envio_test_get->provincias]);
            } 

            if(!empty($filtro_envio_test_get->distritos)){
                $iframes_registros_test = $iframes_registros_test->whereIn('registros_usuarios.id_distrito',[$filtro_envio_test_get->distritos]);
            } 

            if(!empty($filtro_envio_test_get->carreras)){
                $iframes_registros_test = $iframes_registros_test->where(function ( $query) use ($filtro_envio_test_get){
                    $query->whereIn('iframes_registros_test.carrera_1', [$filtro_envio_test_get->carreras])
                        ->orWhereIn('iframes_registros_test.carrera_2', [$filtro_envio_test_get->carreras])
                        ->orWhereIn('iframes_registros_test.carrera_3', [$filtro_envio_test_get->carreras]);
                });
            } 


            if(!empty($filtro_envio_test_get->instituciones)){
                $iframes_registros_test = $iframes_registros_test->where(function ( $query) use ($filtro_envio_test_get){
                    $query->whereIn('iframes_registros_test.institucion_1', [$filtro_envio_test_get->instituciones])
                        ->orWhereIn('iframes_registros_test.institucion_2', [$filtro_envio_test_get->instituciones]);
                });
            }

            $iframes_registros_test = $iframes_registros_test
                                    ->where('iframes_registros_test.id_iframe', $id_iframe)
                                    ->orderBy('iframes_registros_test.fecha_registro', 'desc')
                                    ->get();

                        
            //$iframes_registros_test_data['filtro_envio_test_'.$iframe_filtro_test_id_filtro] = $iframes_registros_test;

            $iframes_registros_test_data[] = [
                'id_filtro_test' => $iframe_filtro_test_id_filtro,
                'titulo_filtro_test' => $filtro_envio_test_get->titulo,
                'result' => $iframes_registros_test
                ];  

        }

        return $iframes_registros_test_data;
    }
}
