<?php

namespace App\Http\Controllers\Api\V1;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use DB;
use Illuminate\Http\Response;


use App\Http\Validators\AudioValidators;
use Illuminate\Support\Facades\Validator;
use Storage;

class AudioController extends Controller
{


    public function insertar(Request $request){

        $data = $request->input();

        $rules = AudioValidators::$insertar;
        $validator = Validator::make($data, $rules);

        if ($validator->fails()) {
            $message = null;
            foreach ($validator->errors()->getMessages() as $messageError) {
                foreach ($messageError as $error) {
                    $message .= "\n" . $error;
                }
            }
            return response()->json(['error' => trans('messages.generic.validation') . ' ' . $message], Response::HTTP_BAD_REQUEST);
        }

        
        $usuario = DB::table('usuarios')
        ->select('*')
        ->where('id_usuario',$data['id_usuario'])
        ->get();

        if (count($usuario)<=0) {
            return response()->json(['error' => trans('messages.user.not_found')], Response::HTTP_NOT_FOUND);
        }

        $name_file = time().".mp3";
        $values = array(
                        'id_usuario' => $usuario[0]->id_usuario,
                        'id_pro' => $data['id_pro'],
                        'file_music' => $data['file_music'],
                        'fecha' => $data['fecha'],
                        'status' => $data['status'],
                        'url_base64' => $data['url_base64'],
                        'name_file' => $name_file
                    );

        $insertar = DB::table('record_strem')->insert($values);

        //Agregamos el archivo BASE64 a carpeta
        Storage::put($name_file.".mp3", base64_decode($data['url_base64']));
        
        return response()->json([
            'response' => Response::HTTP_OK,
            'result' => $insertar
]);

    }

    public function insertar2(){
        echo 'hola';
        exit();

        $usuario = DB::table('usuarios')
                                ->select('*')
                                ->where('id_usuario',$user->id)
                                ->where('flstatus',1)
                                ->get();

        if (is_null($user)) {
            return response()->json(['error' => trans('messages.user.not_found')], Response::HTTP_NOT_FOUND);
        }

        $instituciones_educativas = DB::table('users_institucion')
                                ->select('users_institucion.id_institucion')
                                ->where('id_user',$user->id)
                                ->where('flstatus',1)
                                ->get();

        $instituciones_educativas_id = [];

        foreach ($instituciones_educativas as $institucion_educativa){
            $id_instituciones = explode(",",$institucion_educativa->id_institucion);
            $instituciones_educativas_id = $id_instituciones;
        }

        $registros_llamadas=[];

        foreach ($instituciones_educativas_id as $institucion_educativa_id){
            $llamadas = Llamada::select(
                'registros_llamadas.id',
                'registros_llamadas.id_institucion',
                'instituciones_educativas.title as nombre_institucion',
                'instituciones_educativas.alias as alias_institucion',
                'registros_llamadas.ip',
                'registros_llamadas.telefono',
                'registros_llamadas.telefono_usuario',
                'registros_llamadas.fecha'
                )
            ->join('instituciones_educativas', 'instituciones_educativas.id', '=', 'registros_llamadas.id_institucion')
            ->where('registros_llamadas.id_institucion',$institucion_educativa_id)
            ->get();

            $registros_llamadas[] = [
                                    'id' => $institucion_educativa_id,
                                    'result' => $llamadas
                                    ];  
        }

        return response()->json([
                    'response' => Response::HTTP_OK,
                    'result' => $registros_llamadas
        ]);

    }
}
